#ifndef SYS_HWCFG_H
#define SYS_HWCFG_H

/*----------------------------------------------------------------------------
 * Package: SYS_HWCFG.H
 * Purpose: This package defines the hardware adaptation value for the project.
 * Note: The naming constant defined in this package shall be reused by
 *        all the BNBU L2/L3 switch projects .
 *  History
 *
 *   ryan     07/16/2001      new created
 *   jjyoung  10/21/2002      modified for Alps(XGS) project
 *
 * ------------------------------------------------------------------------
 * Copyright(C)                             ACCTON Technology Corp. , 2001
 * ------------------------------------------------------------------------
 */


/* INCLUDE FILE DECLARATIONS
 */
#include "sys_type.h"
#include "sys_dflt.h"
#include "sys_hwcfg_common.h"

/* Flash device type :
 *
 * SYS_HWCFG_FLASH_MEM_INTEL_28F160B3   : for Intel 28F160B3
 * SYS_HWCFG_FLASH_MEM_INTEL_28F320C3BA : for Intel 28F320C3BA
 * SYS_HWCFG_FLASH_MEM_INTEL_28F320J3A  : for Intel 28F320J3A
 * SYS_HWCFG_FLASH_MEM_INTEL_28F640J3A  : for Intel 28F640J3
 */
//#define SYS_HWCFG_FLASH_MEM_INTEL_28F128J3A
/* Two of 28F640J3A (64Mbit, 8MByte) Intel Strata Flash memory chips */

/* Data width for a single flash chip */
//#define SYS_HWCFG_FLASH_MEM_DATA_ACCESS_8BIT

/* Data width for a flash block */
//#define SYS_HWCFG_FLASH_MEM_DATA_BANDWIDTH_8BIT

/* How many RCS we use for flash, and the extention start address of flash */
//#define SYS_HWCFG_FLASH_RCS_NUMBER                  3
//#define SYS_HWCFG_FLASH_MEM_EXT_ADDR                0xFF000000  /* 2nd flash chip (NOR) */
//#define SYS_HWCFG_FLASH_MEM_EXT_ADDR_1              0xB0000000  /* 3rd flash chip (NAND) */

//#define SYS_HWCFG_STK_STATUS              0xEA0a0007

/* NAMING CONSTANT DECLARATIONS
 */

/* The constants ROM_TEXT_ADRS, ROM_SIZE, RAM_HIGH_ADRS, and RAM_LOW_ADRS
 * are used in config.h and Makefile.
 * All definitions for these constants must be identical.
 */

/* If you update these constants, you must update the WPJ of BSP */
//#define SYS_HWCFG_ROM_BASE_ADRS           0xfff00000      /* base address of ROM */
//#define SYS_HWCFG_ROM_TEXT_ADRS           (SYS_HWCFG_ROM_BASE_ADRS+0x0100) /* with PC & SP */
//#define SYS_HWCFG_ROM_WARM_ADRS           (SYS_HWCFG_ROM_TEXT_ADRS+0x0004) /* warm reboot entry */
//#define SYS_HWCFG_ROM_SIZE                0x00008000      /* 32KB ROM space */
//#define SYS_HWCFG_RAM_LOW_ADRS            0x00010000      /* RAM address for vxWorks */
//#define SYS_HWCFG_RAM_HIGH_ADRS           0x07B00000      /* RAM address for bootrom */


/* FLASH Memory Mapping
 * Note: The following information will be stored in the 8M bytes flash memory:
 *       1. Loader image                    - 32K bytes
 *       2. Agent board information         - 256 bytes
 *       3. main board information          - 256 bytes
 *       4. flash disk system               - (8M - 32K - 256 - 256) bytes
 *          - system confguration data file
 *          - PROM image file in compressed format
 *          - Run Time (Agent) image file in compressed format
 *          - System log file
 *          - Error log file
 */

//#define SYS_HWCFG_FLASH_MEM_BASE_ADDR               0xFE000000  /* 1st flash chip (NOR) */
#define SYS_HWCFG_FLASH_MEM_SIZE                    (32 * SYS_TYPE_1M_BYTES)
//#define SYS_HWCFG_FLASH_MAX_RCS0_CONFIG_SIZE        (16 * SYS_TYPE_1M_BYTES)

/* LOADER Image Memory Mapping
 * Note: Reserve 32K bytes flash for Loader image.
 */
//#define SYS_HWCFG_LOADER_START_ADDR                   0xFFF00100
//#define SYS_HWCFG_LOADER_CODE_SIZE                  (64 * SYS_TYPE_1K_BYTES)

/* Loader Parameters, needed by loader */
//#define SYS_HWCFG_LOADER_DOWNLOAD_BUFFER_ADDRESS    0x07800000
//#define SYS_HWCFG_LOADER_DOWNLOAD_BUFFER_SIZE       0x00600000
//#define   SYS_HWCFG_LOADER_APPLICATION_START_ADDRESS  0x00010000

//#define BSP_DownloadBuffer                          SYS_HWCFG_LOADER_DOWNLOAD_BUFFER_ADDRESS
//#define BSP_DownloadBufferSize                      SYS_HWCFG_LOADER_DOWNLOAD_BUFFER_SIZE
//#define BSP_ApplicationStartAddress                 SYS_HWCFG_LOADER_APPLICATION_START_ADDRESS


/* Agent/Main Board Info Memory Mapping
 * Note: 1. Reserve 256 bytes for agent board information.
 *       2. Reserve 256 bytes for main board information.
 */
//#define SYS_HWCFG_AGENT_BOARD_INFO_START_ADDR       0xFE020000  /* Block 1: save H/W info */
//#define SYS_HWCFG_AGENT_BOARD_INFO_BUF_SIZE         SYS_TYPE_256_BYTES

//#define SYS_HWCFG_MAIN_BOARD_INFO_START_ADDR        (SYS_HWCFG_AGENT_BOARD_INFO_START_ADDR + SYS_HWCFG_AGENT_BOARD_INFO_BUF_SIZE)
//#define SYS_HWCFG_MAIN_BOARD_INFO_BUF_SIZE          SYS_TYPE_256_BYTES

/* Start Address of Flash Reserve Blocks
 * Note: 1. Support max 8 reserve blocks.
 *         2. Start address 0x00000000 means that reserve block is not used.
 *********************************************************
 ******** jerry.du modify 20080605, Flash Map Patition Layout *********
 *********************************************************
 */
#define SYS_HWCFG_POE_UART_CONTROL_SYSFUN       0x1
#define SYS_HWCFG_POE_UART_CONTROL_SDK          0x2
#define SYS_HWCFG_POE_UART_CONTROL_TYPE       SYS_HWCFG_POE_UART_CONTROL_SYSFUN 

/* Need to follow loader's design, thomas */
#if 0
#define SYS_HWCFG_FLASH_PARTITION_NUM               7
#define SYS_HWCFG_FLASH_TYPE_HRCW                   1
#define SYS_HWCFG_FLASH_TYPE_KERNEL                 2
#define SYS_HWCFG_FLASH_TYPE_ROOTFS                 3
#define SYS_HWCFG_FLASH_TYPE_USERDATA               4
#define SYS_HWCFG_FLASH_TYPE_LOADER                 5
#define SYS_HWCFG_FLASH_TYPE_LOADERDATA             6
#define SYS_HWCFG_FLASH_TYPE_HWINFO                 7
#define SYS_HWCFG_FLASH_TYPE_SYSINFO                8
#define SYS_HWCFG_FLASH_TYPE_SYSCONFIG              9
#define SYS_HWCFG_FLASH_RESERVE_BLOCK0_START_ADDR   0xF8000000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK1_START_ADDR   0xF8080000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK2_START_ADDR   0xF80A0000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK3_START_ADDR   0xF80B0000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK4_START_ADDR   0xF80D0000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK5_START_ADDR   0xF80F0000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK6_START_ADDR   0xF81F0000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK0_SIZE   0x00080000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK1_SIZE   0x00020000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK2_SIZE   0x00010000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK3_SIZE   0x00020000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK4_SIZE   0x00020000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK5_SIZE   0x00100000
#define SYS_HWCFG_FLASH_RESERVE_BLOCK6_SIZE   0x005F0000
#endif
#define ARRAY_SIZE(a)   (sizeof(a)/sizeof(a[0]))

/*SIH: Single Image Higtlight*/
#define SYS_HWCFG_IS_26_PORT_BOARD(board_id)  (board_id == 1 || board_id == 2)
#define SYS_HWCFG_IS_52_PORT_BOARD(board_id)  (board_id == 0 || board_id == 4 || \
                                               board_id == 7 || board_id == 8)
#define SYS_HWCFG_IS_28_PORT_BOARD(board_id)  (board_id == 3 || board_id == 5 || \
                                               board_id == 6 || board_id == 11 || \
                                               board_id == 12 || board_id == 13 || \
                                               board_id == 15 )

#define SYS_HWCFG_IS_12_PORT_BOARD(board_id)  (board_id == 9 || board_id == 10 || \
                                               board_id == 14)  

#define SYS_HWCFG_IS_CO_BOARD(board_id)  (board_id == 3 || board_id == 5 || \
                            board_id == 6 ||board_id == 7 || board_id == 8)

#define SYS_HWCFG_IS_28_PORT_HAS_COMBO_PORT(board_id)  (board_id == 11 || board_id == 15)

#define SYS_HWCFG_IS_BI_COLOR(board_id)       (board_id == 6 || board_id == 8 || board_id == 13)
#define SYS_HWCFG_IS_ONE_COLOR(board_id)      (board_id == 3 || board_id == 5 || \
                                               board_id == 7)

#define SYS_HWCFG_IS_SYS_FAULT_LED_NO_BLINKING(board_id)  (board_id == 6 || board_id == 8 || \
                                                           board_id == 10 || board_id == 13)

#define SYS_HWCFG_IS_BOARD_NO_SFP_PRESENT(board_id) (board_id == 3  || board_id == 5 || \
                                                     board_id == 6  || board_id == 7 || \
                                                     board_id == 8  || board_id == 11|| \
                                                     board_id == 12 || board_id == 13 || \
                                                     board_id == 15)

/* On some boards, TX_DISABLEs are driven from PHY, no extra control is needed */
#define SYS_HWCFG_IS_BOARD_NO_TX_DISABLE(board_id) (board_id ==  0 || board_id ==  3 || board_id ==  4 || \
                                                    board_id ==  5 || board_id ==  6 || board_id ==  7 || \
                                                    board_id ==  8 || board_id ==  9 || board_id == 10 || \
                                                    board_id == 11 || board_id == 12 || board_id == 13 || \
                                                    board_id == 14 || board_id == 15)

#define SYS_HWCFG_IS_BOARD_SUPPORT_TX_DISABLE(board_id) (board_id == 1 || board_id == 2)

#define SYS_HWCFG_IS_BOARD_THERMAL_LM75(board_id) (board_id ==  0 || board_id ==  1 || \
                                                   board_id ==  2 || board_id ==  4 || \
                                                   board_id ==  9 || board_id == 10 || \
                                                   board_id == 11 || board_id == 12 || \
                                                   board_id == 14 || board_id == 15)

#define SYS_HWCFG_IS_BOARD_THERMAL_LM77(board_id) (board_id ==  3 || board_id ==  5 || \
                                                   board_id ==  6 || board_id ==  7 || \
                                                   board_id ==  8 || board_id == 13)

#define SYS_HWCFG_FLASH_TYPE          SYS_HWCFG_FLASH_TYPE_NOR
#define SYS_HWCFG_LOADER_FLASH_TYPE   SYS_HWCFG_FLASH_TYPE_NOR
#define SYS_HWCFG_HWINFO_FLASH_TYPE   SYS_HWCFG_FLASH_TYPE_NOR
#define SYS_HWCFG_RUNTIME_FLASH_TYPE  SYS_HWCFG_FLASH_TYPE_NOR

#define SYS_HWCFG_MV_ONE_FLASH_DRIVER   TRUE
#define SYS_HWCFG_MV_98DX3035_DEVICE_ID  0x000e7fe3  /* 28 port GE )*/
#define SYS_HWCFG_MV_98DX3036_DEVICE_ID  0x000df703  /* 52 port GE )*/
/* PCI device
 */
#define SYS_HWCFG_SUPPORT_PCI                       FALSE

#define SYS_HWCFG_I2C_DEFAULT_BUS_IDX           (0)

/* The number of thermal for different board_id
 * is not the same.
 */
#define SYS_HWCFG_SUPPORT_DIFFERENT_THERMAL_NUM     TRUE

/* Flash Disk Memory Mapping
 */
//#define SYS_HWCFG_FLASH_DISK_START_ADDR               (SYS_HWCFG_MAIN_BOARD_INFO_START_ADDR + SYS_HWCFG_MAIN_BOARD_INFO_BUF_SIZE)
//#define SYS_HWCFG_FLASH_DISK_SIZE                   (SYS_HWCFG_FLASH_MEM_BASE_ADDR + SYS_HWCFG_FLASH_MEM_SIZE - SYS_HWCFG_FLASH_DISK_START_ADDR)

/* DRAM Memory Mapping and Clock Setting
 */
#define SYS_HWCFG_DRAM_BASE_ADDR                    0x00000000
#define SYS_HWCFG_DRAM_SIZE                         (256 * SYS_TYPE_1M_BYTES) /* Need to change to 128 later, thomas */
#define SYS_HWCFG_USER_RESERVED_MEM_SIZE            (2 * SYS_TYPE_1M_BYTES) /* For UC only */

/* This setting value will impact the UART baud rate as well  */

/* Define the Decremental Clock Rate.
   Note:  If No RTC is supported, this value must be filled in.
 */
/* This setting value will impact the UART baud rate as well  */
//#define SYS_HWCFG_INPUT_CLOCK_FREQ                  100000000
//#define SYS_HWCFG_DRAM_CLOCK_FREQ                   100000000
//#define SYS_HWCFG_MAIN_CLOCK_FREQ                   (SYS_HWCFG_INPUT_CLOCK_FREQ*4)
//#define SYS_HWCFG_BRG_CLOCK_FREQ                    (SYS_HWCFG_MAIN_CLOCK_FREQ/4)

/* Define the Decremental Clock Rate.
 * Note:  If No RTC is supported, this value must be filled in.
 */
//#define SYS_HWCFG_DEC_CLOCK_FREQ                    (SYS_HWCFG_INPUT_CLOCK_FREQ/4)
#if 0
#define SYS_HWCFG_DRAM_CLOCK_FREQ                   133000000
#define SYS_HWCFG_DEC_CLOCK_FREQ                    33000000
#endif

//#define SYS_CLK_RATE 100

#define CONSOLE_BAUD_RATE 115200
/* System Interrupt Vector Table
 */
//#define SYS_HWCFG_INTR_VECTOR_BASE_ADDR             SYS_HWCFG_DRAM_BASE_ADDR
//#define SYS_HWCFG_INTR_VECTOR_TABLE_SIZE            (12 * SYS_TYPE_1K_BYTES)

/* Unclear Memory Mapping
 * 1. Warm Boot: Stack Topology Change, Software Reset/Restart Request
 * 2. System Log
 * 3. Please make sure you know everything will use UC and allocate enough memory
 */
#define SYS_HWCFG_UC_MEM_SIZE                       SYS_HWCFG_USER_RESERVED_MEM_SIZE

/* Realtak Project will use the top memory to handle packet tx and rx, so reserve 2M for DMA and DESC
 *  #define RTL8380_DMA_PHYS_BASE       0x0FF00000
 *  #define RTL8380_DESC_PHYS_BASE      0x0FE00000
 */
#define SYS_HWCFG_UC_MEM_END_ADDR                   (SYS_HWCFG_DRAM_BASE_ADDR + SYS_HWCFG_DRAM_SIZE - 1  - 2*SYS_TYPE_1M_BYTES)
#define SYS_HWCFG_UC_MEM_START_ADDR                 (SYS_HWCFG_UC_MEM_END_ADDR + 1 - SYS_HWCFG_UC_MEM_SIZE  - 2*SYS_TYPE_1M_BYTES)

/* LAN Buffer Static Memory Mapping
 * Why static?  Because we want to allocate these packet buffer and be used by NIC driver.
 * But for NIC driver, it could use PCI DMA to write to these buffers directly and these
 * memory space can not be cached.  So we need to separate the buffer from the normal memory
 * area.
 */
/* Moved to SYS_ADPT.H. 5/6/2004, Charles, requested by Wuli
 */
/*
#define SYS_HWCFG_MAX_LAN_RX_BUF_SIZE_PER_PACKET    1600
#define SYS_HWCFG_MAX_NBR_OF_LAN_PACKET_RX_BUFFER   512
#define SYS_HWCFG_LAN_BUF_SIZE                      (SYS_HWCFG_MAX_LAN_RX_BUF_SIZE_PER_PACKET * SYS_HWCFG_MAX_NBR_OF_LAN_PACKET_RX_BUFFER)
*/
#define SYS_HWCFG_LAN_BUF_START_ADDR                (SYS_HWCFG_UC_MEM_END_ADDR + 1 - SYS_HWCFG_USER_RESERVED_MEM_SIZE)

/* PROM/Run Time Image Memory Mapping/Working Area
 * NOTE: 1. The following naming constants are used to define the image header of PROM/Run Time code.
 *       2. The TFTP/XMODEM download utility shall verify the image header of downloaded PROM/Run Time code
 *       3. The BOOT LOADER shall load the PROM/Run Time code to the proper working area based on
 *          the SYS_HWCFG_PROM_CODE_START_ADDR/SYS_HWCFG_RUN_CODE_START_ADDR defined in image header.
 */
//#define SYS_HWCFG_PROM_CODE_START_ADDR              (SYS_HWCFG_DRAM_BASE_ADDR + SYS_HWCFG_INTR_VECTOR_TABLE_SIZE)
//#define SYS_HWCFG_RUN_CODE_START_ADDR               SYS_HWCFG_PROM_CODE_START_ADDR


/* Define LED display address
 */

/*RCS1 bank range 0xE0100000 ~ 0xE010000F*/
#define SYS_HWCFG_RCS1_BASE                 0xE0100000



/* Push Button (Read Only, 0xE0100000)
 * -----------------------------------------------------------------------------------------
 * |            7        |              6              |        5        |        4        |        3        |          2        |         1       |          0      |
 * |-----------|---------------|------------------------------------------------------------|
 * |Master/Slave|Stacking/Up-Link| Reserved | Reserved | Reserved |  Reserved  | Reserved | Reserved |
 * -----------------------------------------------------------------------------------------
 Master/Slave:
        1: Master
        0: Slave
 Stacking/Up-Link:
        1: Stacking
        0: Up-Link
 */
#define SYS_HWCFG_STACK_BUTTON_ADDR                 (SYS_HWCFG_CPLD_BASE + 0x00) /* 0xE0100000 */

/* Stacking status (Read Only, 0xE0100000)
  */
#define SYS_HWCFG_STACK_STATUS_ADDR                 SYS_HWCFG_STACK_BUTTON_ADDR
#define SYS_HWCFG_STACK_BUTTON_MASK                 0x80    /* 10000000 */
#define SYS_HWCFG_STACK_BUTTON_PRESSED              0x80

#define SYS_HWCFG_BUTTON_STACKING_ADDR              SYS_HWCFG_STACK_BUTTON_ADDR
#define SYS_HWCFG_BUTTON_STACKING_MASK              0x40
#define SYS_HWCFG_BUTTON_STACKING_PRESSED           0x40

/* System Reset (Read/Write, 0xE0100001)
 * ------------------------------------------------------------------------------------------------
 * |         7       |        6        |       5         |            4            |         3       |             2               |             1              |         0       |
 * |-----------------------------|-------------|---------|---------------|-------------------------|
 * | Reserved | Reserved | Reserved |Reset Cold Start| Reserved |Reset BCM5248U|Reset BCM5482S| Reserved |
 * ------------------------------------------------------------------------------------------------
 Reset Cold Start:
        1: A low to high transition will cause a system level hardware reset when N_WDT_DIS is set to low.
            Set this bit high to enable watchdog timer to trigger a hardware-reset when watchdog time out.
        0: Disable watchdog timer reset and hardware reset
 Reset BCM5248:
        1: BCM5248 are placed in normal operation state
        0: BCM5248 are placed in reset state
 Reset BCM5482S:
        1: BCM5482S are placed in normal operation state
        0: BCM5482S are placed in reset state
 */
#define SYS_HWCFG_SYSTEM_RESET_ADDR                 (SYS_HWCFG_CPLD_BASE + 0x01) /* 0xE0100001 */

#define SYS_HWCFG_RESET_COLDSTART_ADDR              SYS_HWCFG_SYSTEM_RESET_ADDR
#define SYS_HWCFG_RESET_COLDSTART_MASK              0x10
#define SYS_HWCFG_RESET_COLDSTART_RESET             0x10
#define SYS_HWCFG_RESET_COLDSTART_NORMAL            0x00

#define SYS_HWCFG_RESET_PHY_ADDR                    SYS_HWCFG_SYSTEM_RESET_ADDR
#define SYS_HWCFG_RESET_PHY_MASK                    0x06
#define SYS_HWCFG_RESET_PHY_RESET                   0x06
#define SYS_HWCFG_RESET_PHY_NORMAL                  0x00

#define SYS_HWCFG_RESET_BUTTON_ACCESS_METHOD        SYS_HWCFG_REG_ACCESS_METHOD_SYS_HWCFG_API

/* Clear NMI(Read Only, 0xE0100004)
 * ---------------------------------------------------------------------------------------
 * |               7               |        6       |         5       |        4        |        3        |       2        |         1        |         0       |
 * |----------------|---------------------------------------------------------------------|
 * |Watchdog Time out| Reserved | Reserved | Reserved | Reserved | Reserved | Reserved | Reserved |
 * ---------------------------------------------------------------------------------------
 Watchdog Time out:
        1: Watchdog timer expired
        0: Watchdog timer is not enabled or is progressing.
 */


#define SYS_HWCFG_WATCHDOG_TYPE                    SYS_HWCFG_WATCHDOG_GPIO_TPS3705

/* Port LED mode configuration.
 * Refer to "0xBB00A004" section of RTL838x_RTL833x_RegisterFile_V1.4.pdf
 */
#define SYS_HWCFG_PORT_0_23_LED0_MODE_BIT_START         (0)  /*[4:0] of 0xBB00A004*/
#define SYS_HWCFG_PORT_0_23_LED1_MODE_BIT_START         (5)  /*[9:5] of 0xBB00A004*/
#define SYS_HWCFG_PORT_24_27_LED0_MODE_BIT_START        (15)  /*[19:15] of 0xBB00A004*/
#define SYS_HWCFG_PORT_24_27_LED1_MODE_BIT_START        (20)  /*[24:20] of 0xBB00A004*/

#define SYS_HWCFG_PORT_LED_MODE_BIT_WIDTH           (5)
#define SYS_HWCFG_PORT_LED_MODE_BIT_MASK            ((1<<SYS_HWCFG_PORT_LED_MODE_BIT_WIDTH)-1)

#define SYS_HWCFG_PORT_0_23_LED0_MODE_MASK         (SYS_HWCFG_PORT_LED_MODE_BIT_MASK<<SYS_HWCFG_PORT_0_23_LED0_MODE_BIT_START)
#define SYS_HWCFG_PORT_0_23_LED1_MODE_MASK         (SYS_HWCFG_PORT_LED_MODE_BIT_MASK<<SYS_HWCFG_PORT_0_23_LED1_MODE_BIT_START)
#define SYS_HWCFG_PORT_24_27_LED0_MODE_MASK        (SYS_HWCFG_PORT_LED_MODE_BIT_MASK<<SYS_HWCFG_PORT_24_27_LED0_MODE_BIT_START)
#define SYS_HWCFG_PORT_24_27_LED1_MODE_MASK        (SYS_HWCFG_PORT_LED_MODE_BIT_MASK<<SYS_HWCFG_PORT_24_27_LED1_MODE_BIT_START)

/* Green Led for 1000M, Amber Led for 10/100M.
 * Refer to "Led status definition" section of RTL8380M_RTL8382M_RTL8382L_LED_Application note_V1.0.pdf.
 */
#define SYS_HWCFG_PORT_LED_MODE_1000M_LNK_ACT        (0x0A)
#define SYS_HWCFG_PORT_LED_MODE_10_100M_LNK_ACT      (0x0F)

/* Diag LED */
#define SYS_HWCFG_SYSTEM_DIAG_LED_ADDR              SYS_HWCFG_SYSTEM_LED_1_ADDR
#define SYS_HWCFG_SYSTEM_DIAG_LED_MASK              0xC0
#define SYS_HWCFG_SYSTEM_DIAG_SHIFT                 6
#define SYS_HWCFG_SYSTEM_DIAG_OK                    0x80
#define SYS_HWCFG_SYSTEM_DIAG_FAIL                  0x40
#define SYS_HWCFG_SYSTEM_DIAG_OFF                   0xC0

/* Master/Slave LED */
#define SYS_HWCFG_SYSTEM_BASE_LED_ADDR              SYS_HWCFG_SYSTEM_LED_1_ADDR
#define SYS_HWCFG_SYSTEM_BASE_LED_MASK              0x30
#define SYS_HWCFG_SYSTEM_BASE_LED_SHIFT             4
#define SYS_HWCFG_SYSTEM_BASE_MASTER_UNIT           0x20
#define SYS_HWCFG_SYSTEM_BASE_SECOND_UNIT           0x10
#define SYS_HWCFG_SYSTEM_BASE_OTHER_UNIT            0x30


#define SYS_HWCFG_SYSTEM_BASE_MASTER_UNIT           0x20
#define SYS_HWCFG_SYSTEM_BASE_SECOND_UNIT           0x10
#define SYS_HWCFG_SYSTEM_BASE_OTHER_UNIT            0x30


#define SYS_HWCFG_EPLD_PAGE_SIZE        0x54       /* for accessing CPU registers */
#define SYS_HWCFG_EPLD_PAGE1_ADDR       0xF1010100 /* for accessing CPU registers */
#define SYS_HWCFG_EPLD_MIN_PAGE         1
#define SYS_HWCFG_EPLD_MAX_PAGE         2

/* Power Status
 */
#define SYS_HWCFG_MODE_BUTTON_MASK                 0x02
#define SYS_HWCFG_MODE_BUTTON_PRESSED              0x00


#define SYS_HWCFG_POWER_STATUS_ADDR_ARRAY           {0, 0}  /*number should match SYS_ADPT_MAX_NBR_OF_POWER_PER_UNIT*/
#define SYS_HWCFG_POWER_STATUS_REG_ACCESS_METHOD    SYS_HWCFG_REG_ACCESS_METHOD_SYS_HWCFG_API


#if (SYS_CPNT_POE_ASIC==SYS_CPNT_POE_ASIC_POWERDSINE)
/*For PD69xxx, bank is 4 bit value combined by 4 bits from pin PGD1~4.
 *For ecs4100-PoE,
 *   All PGOOD pin is tie to 0.
 */
#define SYS_HWCFG_POWER_BANK_BIT_POSITION           {0}

/* only 1 possible banks: Bank 0.
 */
#define SYS_HWCFG_POWER_BANKS                       {0}
#endif

/*For ECS2000, no needs to check presented before read status
 *But given nominal OK and MASK bits.
 */
#define SYS_HWCFG_PWR_STATUS_OK                       0x01
#define SYS_HWCFG_PWR_STATUS_MASK                     0x01
#define SYS_HWCFG_PWR_PRES_OK                         0x02
#define SYS_HWCFG_PWR_PRES_MASK                       0x02
#define SYS_HWCFG_RPS_STATUS_OK                       0x10
#define SYS_HWCFG_RPS_STATUS_MASK                     0x10
#define SYS_HWCFG_RPS_PRES_OK                         0x20
#define SYS_HWCFG_RPS_PRES_MASK                       0x20

/* Define Module Present and Link Detected Register Address
 */
#define SYS_HWCFG_SFP_PRESENT_STATUS_ACCESS_METHOD SYS_HWCFG_REG_ACCESS_METHOD_SYS_HWCFG_API



/* Keep I2C channel 0 for POE and channel 5 for CPLD open.
 */
//#define SYS_HWCFG_PCA9548_CHANNELS_ALWAYS_SET (BIT_VALUE(0) | BIT_VALUE(5))

#define SYS_HWCFG_PORT25_SFP_STATUS_ADDR 0
#define SYS_HWCFG_PORT26_SFP_STATUS_ADDR 0
#define SYS_HWCFG_PORT27_SFP_STATUS_ADDR 0
#define SYS_HWCFG_PORT28_SFP_STATUS_ADDR 0

#define SYS_HWCFG_SFP_STATUS_ADDR_ARRAY_BODY \
        SYS_HWCFG_PORT25_SFP_STATUS_ADDR, \
        SYS_HWCFG_PORT26_SFP_STATUS_ADDR, \
        SYS_HWCFG_PORT27_SFP_STATUS_ADDR, \
        SYS_HWCFG_PORT28_SFP_STATUS_ADDR

#define SYS_HWCFG_PORT25_SFP_MODULE_PRESENT_BIT_SHIFT 0
#define SYS_HWCFG_PORT26_SFP_MODULE_PRESENT_BIT_SHIFT 0
#define SYS_HWCFG_PORT27_SFP_MODULE_PRESENT_BIT_SHIFT 0
#define SYS_HWCFG_PORT28_SFP_MODULE_PRESENT_BIT_SHIFT 0

#define SYS_HWCFG_PORT49_SFP_MODULE_PRESENT_BIT_SHIFT 2
#define SYS_HWCFG_PORT50_SFP_MODULE_PRESENT_BIT_SHIFT 0
#define SYS_HWCFG_PORT51_SFP_MODULE_PRESENT_BIT_SHIFT 1
#define SYS_HWCFG_PORT52_SFP_MODULE_PRESENT_BIT_SHIFT 3

#define SYS_HWCFG_PORT25_SFP_MODULE_TX_DISABLE_BIT_SHIFT 0
#define SYS_HWCFG_PORT26_SFP_MODULE_TX_DISABLE_BIT_SHIFT 0
#define SYS_HWCFG_PORT27_SFP_MODULE_TX_DISABLE_BIT_SHIFT 0
#define SYS_HWCFG_PORT28_SFP_MODULE_TX_DISABLE_BIT_SHIFT 0

#define SYS_HWCFG_PORT49_SFP_MODULE_TX_DISABLE_BIT_SHIFT 2
#define SYS_HWCFG_PORT50_SFP_MODULE_TX_DISABLE_BIT_SHIFT 0
#define SYS_HWCFG_PORT51_SFP_MODULE_TX_DISABLE_BIT_SHIFT 1
#define SYS_HWCFG_PORT52_SFP_MODULE_TX_DISABLE_BIT_SHIFT 3
/* If this constant is defined, an array for present bit shift of each combo
 * port will be declared in stktplg_om.c
 */
#define SYS_HWCFG_SFP_MODULE_PRESENT_BIT_SHIFT_ARRAY_BODY SYS_HWCFG_SFP_MODULE_PRESENT_BIT_SHIFT_ARRAY_BODY_BID_0_1

#define SYS_HWCFG_SFP_MODULE_PRESENT_BIT_SHIFT_ARRAY_BODY_BID_0_1 \
    SYS_HWCFG_PORT25_SFP_MODULE_PRESENT_BIT_SHIFT, \
    SYS_HWCFG_PORT26_SFP_MODULE_PRESENT_BIT_SHIFT, \
    SYS_HWCFG_PORT27_SFP_MODULE_PRESENT_BIT_SHIFT, \
    SYS_HWCFG_PORT28_SFP_MODULE_PRESENT_BIT_SHIFT

#define SYS_HWCFG_SFP_MODULE_PRESENT_BIT_SHIFT_ARRAY_BODY_BID_2_3 \
    SYS_HWCFG_PORT49_SFP_MODULE_PRESENT_BIT_SHIFT, \
    SYS_HWCFG_PORT50_SFP_MODULE_PRESENT_BIT_SHIFT, \
    SYS_HWCFG_PORT51_SFP_MODULE_PRESENT_BIT_SHIFT, \
    SYS_HWCFG_PORT52_SFP_MODULE_PRESENT_BIT_SHIFT

#define SYS_HWCFG_SFP_MODULE_TX_DISABLE_BIT_SHIFT_ARRAY_BODY SYS_HWCFG_SFP_MODULE_TX_DISABLE_BIT_SHIFT_ARRAY_BODY_BID_0_1

#define SYS_HWCFG_SFP_MODULE_TX_DISABLE_BIT_SHIFT_ARRAY_BODY_BID_0_1\
    SYS_HWCFG_PORT25_SFP_MODULE_TX_DISABLE_BIT_SHIFT, \
    SYS_HWCFG_PORT26_SFP_MODULE_TX_DISABLE_BIT_SHIFT, \
    SYS_HWCFG_PORT27_SFP_MODULE_TX_DISABLE_BIT_SHIFT, \
    SYS_HWCFG_PORT28_SFP_MODULE_TX_DISABLE_BIT_SHIFT

#define SYS_HWCFG_SFP_MODULE_TX_DISABLE_BIT_SHIFT_ARRAY_BODY_BID_2_3 \
    SYS_HWCFG_PORT49_SFP_MODULE_TX_DISABLE_BIT_SHIFT, \
    SYS_HWCFG_PORT50_SFP_MODULE_TX_DISABLE_BIT_SHIFT, \
    SYS_HWCFG_PORT51_SFP_MODULE_TX_DISABLE_BIT_SHIFT, \
    SYS_HWCFG_PORT52_SFP_MODULE_TX_DISABLE_BIT_SHIFT

#define SYS_HWCFG_PORT25_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT25_SFP_MODULE_PRESENT_BIT_SHIFT)
#define SYS_HWCFG_PORT26_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT26_SFP_MODULE_PRESENT_BIT_SHIFT)
#define SYS_HWCFG_PORT27_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT27_SFP_MODULE_PRESENT_BIT_SHIFT)
#define SYS_HWCFG_PORT28_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT28_SFP_MODULE_PRESENT_BIT_SHIFT)

#define SYS_HWCFG_PORT49_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT49_SFP_MODULE_PRESENT_BIT_SHIFT)
#define SYS_HWCFG_PORT50_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT50_SFP_MODULE_PRESENT_BIT_SHIFT)
#define SYS_HWCFG_PORT51_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT51_SFP_MODULE_PRESENT_BIT_SHIFT)
#define SYS_HWCFG_PORT52_SFP_MODULE_PRESENT_MASK  (1 << SYS_HWCFG_PORT52_SFP_MODULE_PRESENT_BIT_SHIFT)

#define SYS_HWCFG_PORT25_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT25_SFP_MODULE_TX_DISABLE_BIT_SHIFT)
#define SYS_HWCFG_PORT26_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT26_SFP_MODULE_TX_DISABLE_BIT_SHIFT)
#define SYS_HWCFG_PORT27_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT27_SFP_MODULE_TX_DISABLE_BIT_SHIFT)
#define SYS_HWCFG_PORT28_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT28_SFP_MODULE_TX_DISABLE_BIT_SHIFT)

#define SYS_HWCFG_PORT49_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT49_SFP_MODULE_TX_DISABLE_BIT_SHIFT)
#define SYS_HWCFG_PORT50_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT50_SFP_MODULE_TX_DISABLE_BIT_SHIFT)
#define SYS_HWCFG_PORT51_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT51_SFP_MODULE_TX_DISABLE_BIT_SHIFT)
#define SYS_HWCFG_PORT52_SFP_MODULE_TX_DISABLE_MASK  (1 << SYS_HWCFG_PORT52_SFP_MODULE_TX_DISABLE_BIT_SHIFT)

#define SYS_HWCFG_SFP_MODULE_PRESENT_MASK_ARRAY_BODY SYS_HWCFG_SFP_MODULE_PRESENT_MASK_ARRAY_BODY_BID_0_1

#define SYS_HWCFG_SFP_MODULE_PRESENT_MASK_ARRAY_BODY_BID_0_1 \
    SYS_HWCFG_PORT25_SFP_MODULE_PRESENT_MASK, \
    SYS_HWCFG_PORT26_SFP_MODULE_PRESENT_MASK, \
    SYS_HWCFG_PORT27_SFP_MODULE_PRESENT_MASK, \
    SYS_HWCFG_PORT28_SFP_MODULE_PRESENT_MASK

#define SYS_HWCFG_SFP_MODULE_PRESENT_MASK_ARRAY_BODY_BID_2_3 \
    SYS_HWCFG_PORT49_SFP_MODULE_PRESENT_MASK, \
    SYS_HWCFG_PORT50_SFP_MODULE_PRESENT_MASK, \
    SYS_HWCFG_PORT51_SFP_MODULE_PRESENT_MASK, \
    SYS_HWCFG_PORT52_SFP_MODULE_PRESENT_MASK

#define SYS_HWCFG_SFP_MODULE_TX_DISABLE_MASK_ARRAY_BODY SYS_HWCFG_SFP_MODULE_TX_DISABLE_MASK_ARRAY_BODY_BID_0_1

#define SYS_HWCFG_SFP_MODULE_TX_DISABLE_MASK_ARRAY_BODY_BID_0_1 \
    SYS_HWCFG_PORT25_SFP_MODULE_TX_DISABLE_MASK, \
    SYS_HWCFG_PORT26_SFP_MODULE_TX_DISABLE_MASK, \
    SYS_HWCFG_PORT27_SFP_MODULE_TX_DISABLE_MASK, \
    SYS_HWCFG_PORT28_SFP_MODULE_TX_DISABLE_MASK

#define SYS_HWCFG_SFP_MODULE_TX_DISABLE_MASK_ARRAY_BODY_BID_2_3 \
    SYS_HWCFG_PORT49_SFP_MODULE_TX_DISABLE_MASK, \
    SYS_HWCFG_PORT50_SFP_MODULE_TX_DISABLE_MASK, \
    SYS_HWCFG_PORT51_SFP_MODULE_TX_DISABLE_MASK, \
    SYS_HWCFG_PORT52_SFP_MODULE_TX_DISABLE_MASK

/* SFP RX LOS related definitions
 */
#define SYS_HWCFG_GBIC_HAS_RX_LOS TRUE
#define SYS_HWCFG_SFP_RX_LOS_STATUS_ACCESS_METHOD SYS_HWCFG_REG_ACCESS_METHOD_SYS_HWCFG_API

/* On ES3528MV2, rx los status is got from PCA9555 (I2C address 0x20)
 * I/O_0.4 (sfp 1) I/O_0.5 (sfp 2) I/O_0.6 (sfp3) I/O_0.7 (sfp4)
 */
#define SYS_HWCFG_SFP_RX_LOS_ASIC_I2C_ADDRESS SYS_HWCFG_PCA9555_I2C_ADDRESS

#define SYS_HWCFG_PORT25_SFP_RX_LOSS_STATUS_ADDR SYS_HWCFG_PCA9555_INPUT_PORT_0_REG
#define SYS_HWCFG_PORT26_SFP_RX_LOSS_STATUS_ADDR SYS_HWCFG_PCA9555_INPUT_PORT_0_REG
#define SYS_HWCFG_PORT27_SFP_RX_LOSS_STATUS_ADDR SYS_HWCFG_PCA9555_INPUT_PORT_0_REG
#define SYS_HWCFG_PORT28_SFP_RX_LOSS_STATUS_ADDR SYS_HWCFG_PCA9555_INPUT_PORT_0_REG

#define SYS_HWCFG_SFP_RX_LOSS_STATUS_ADDR_ARRAY_BODY \
    SYS_HWCFG_PORT25_SFP_RX_LOSS_STATUS_ADDR, \
    SYS_HWCFG_PORT26_SFP_RX_LOSS_STATUS_ADDR, \
    SYS_HWCFG_PORT27_SFP_RX_LOSS_STATUS_ADDR, \
    SYS_HWCFG_PORT28_SFP_RX_LOSS_STATUS_ADDR

#define SYS_HWCFG_PORT25_SFP_RX_LOSS_BIT_SHIFT 0
#define SYS_HWCFG_PORT26_SFP_RX_LOSS_BIT_SHIFT 0
#define SYS_HWCFG_PORT27_SFP_RX_LOSS_BIT_SHIFT 0
#define SYS_HWCFG_PORT28_SFP_RX_LOSS_BIT_SHIFT 0

#define SYS_HWCFG_PORT49_SFP_RX_LOSS_BIT_SHIFT 4
#define SYS_HWCFG_PORT50_SFP_RX_LOSS_BIT_SHIFT 0
#define SYS_HWCFG_PORT51_SFP_RX_LOSS_BIT_SHIFT 2
#define SYS_HWCFG_PORT52_SFP_RX_LOSS_BIT_SHIFT 6

#define SYS_HWCFG_SFP_MODULE_RX_LOS_BIT_SHIFT_ARRAY_BODY SYS_HWCFG_SFP_MODULE_RX_LOS_BIT_SHIFT_ARRAY_BODY_BID_0_1

#define SYS_HWCFG_SFP_MODULE_RX_LOS_BIT_SHIFT_ARRAY_BODY_BID_0_1 \
    SYS_HWCFG_PORT25_SFP_RX_LOSS_BIT_SHIFT, \
    SYS_HWCFG_PORT26_SFP_RX_LOSS_BIT_SHIFT, \
    SYS_HWCFG_PORT27_SFP_RX_LOSS_BIT_SHIFT, \
    SYS_HWCFG_PORT28_SFP_RX_LOSS_BIT_SHIFT

#define SYS_HWCFG_SFP_MODULE_RX_LOS_BIT_SHIFT_ARRAY_BODY_BID_2_3 \
    SYS_HWCFG_PORT49_SFP_RX_LOSS_BIT_SHIFT, \
    SYS_HWCFG_PORT50_SFP_RX_LOSS_BIT_SHIFT, \
    SYS_HWCFG_PORT51_SFP_RX_LOSS_BIT_SHIFT, \
    SYS_HWCFG_PORT52_SFP_RX_LOSS_BIT_SHIFT

#define SYS_HWCFG_PORT25_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT25_SFP_RX_LOSS_BIT_SHIFT)
#define SYS_HWCFG_PORT26_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT26_SFP_RX_LOSS_BIT_SHIFT)
#define SYS_HWCFG_PORT27_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT27_SFP_RX_LOSS_BIT_SHIFT)
#define SYS_HWCFG_PORT28_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT28_SFP_RX_LOSS_BIT_SHIFT)

#define SYS_HWCFG_PORT49_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT49_SFP_RX_LOSS_BIT_SHIFT)
#define SYS_HWCFG_PORT50_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT50_SFP_RX_LOSS_BIT_SHIFT)
#define SYS_HWCFG_PORT51_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT51_SFP_RX_LOSS_BIT_SHIFT)
#define SYS_HWCFG_PORT52_SFP_RX_LOSS_MASK (1 << SYS_HWCFG_PORT52_SFP_RX_LOSS_BIT_SHIFT)

#define SYS_HWCFG_SFP_MODULE_RX_LOS_MASK_ARRAY_BODY SYS_HWCFG_SFP_MODULE_RX_LOS_MASK_ARRAY_BODY_BID_0_1

#define SYS_HWCFG_SFP_MODULE_RX_LOS_MASK_ARRAY_BODY_BID_0_1 \
    SYS_HWCFG_PORT25_SFP_RX_LOSS_MASK, \
    SYS_HWCFG_PORT26_SFP_RX_LOSS_MASK, \
    SYS_HWCFG_PORT27_SFP_RX_LOSS_MASK, \
    SYS_HWCFG_PORT28_SFP_RX_LOSS_MASK

#define SYS_HWCFG_SFP_MODULE_RX_LOS_MASK_ARRAY_BODY_BID_2_3 \
    SYS_HWCFG_PORT49_SFP_RX_LOSS_MASK, \
    SYS_HWCFG_PORT50_SFP_RX_LOSS_MASK, \
    SYS_HWCFG_PORT51_SFP_RX_LOSS_MASK, \
    SYS_HWCFG_PORT52_SFP_RX_LOSS_MASK

#define SYS_HWCFG_GBIC_RX_LOS_BIT 0x1

/* SYS_HWCFG_SUPPORT_SFP_TX_DISABLE
 * if the device supports to control sfp tx disable signal,
 * define SYS_HWCFG_SUPPORT_SFP_TX_DISABLE as TRUE
 */
#define SYS_HWCFG_SUPPORT_SFP_TX_DISABLE TRUE

/* This bit will tell the bit mask result and telling whether GBIC module is present
 */
#define SYS_HWCFG_GBIC_PRESENT_BIT                      0


/* PIC device numbers, needed by diagnostic
 */
#define SYS_HWCFG_PCI_DEVICE_NUM_1                  21 /* In diag, thomas */
#define SYS_HWCFG_PCI_DEVICE_NUM_2                  22
#define SYS_HWCFG_PCI_DEVICE_NUM_3                  23
#define SYS_HWCFG_PCI_DEVICE_NUM_4                  24
#define SYS_HWCFG_PCI_DEVICE_NUM_5                  25

/*  If this project is multi-chip and need to addr sync for different chips
 */
#define SYS_HWCFG_ADDR_MULTI_CHIP_SYNC              FALSE /* Useless, for future 50 port */

/* Real Time Clock definition
 */
#define SYS_HWCFG_SUPPORT_RTC                       FALSE

#define SYS_HWCFG_EPLD_VERSION_ADDR                 SYS_HWCFG_I2C_SLAVE_CPLD
#define SYS_HWCFG_EPLD_VERSION_ACCESS_METHOD        SYS_HWCFG_REG_ACCESS_METHOD_SYS_HWCFG_API

/* Support PoE PD
 */
#define SYS_HWCFG_SUPPORT_PD                        FALSE

#define SYS_HWCFG_I2C_SLAVE_EEPROM                  0x50
#define SYS_HWCFG_I2C_SLAVE_RETIMER                 0x18

/* kinghong: move from sys_adpt.h: SYS_ADPT_MAX_NBR_OF_THERMAL_PER_UNIT */
#define SYS_HWCFG_MAX_NBR_OF_THERMAL_PER_UNIT       SYS_ADPT_MAX_NBR_OF_THERMAL_PER_UNIT
#define SYS_HWCFG_I2C_SLAVE_THERMAL_0               (0x48)
#define SYS_HWCFG_I2C_SLAVE_THERMAL_CO              (0x4a)
#define SYS_HWCFG_I2C_SLAVE_THERMAL_BID_ARRAY { \
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 0*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 1*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 2*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 3*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 4*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_CO, /*BID 5*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_CO, /*BID 6*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_CO, /*BID 7*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_CO, /*BID 8*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_CO, /*BID 9*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 10*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 11*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 12*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_CO,/*BID 13*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_CO,/*BID 14*/\
                                                SYS_HWCFG_I2C_SLAVE_THERMAL_0, /*BID 15*/}

#define SYS_HWCFG_MAX_NBR_OF_FAN_PER_UNIT            SYS_ADPT_MAX_NBR_OF_FAN_PER_UNIT
#define SYS_HWCFG_I2C_SLAVE_FAN_0                   (0x2F)
#define SYS_HWCFG_FAN_ADRR_ARRAY       {SYS_HWCFG_I2C_SLAVE_FAN_0, \
                                        SYS_HWCFG_I2C_SLAVE_FAN_0, \
                                        SYS_HWCFG_I2C_SLAVE_FAN_0, \
                                        SYS_HWCFG_I2C_SLAVE_FAN_0}
#define SYS_HWCFG_FAN_HAS_FULL_SPEED_PIN            (TRUE)

#define SYS_HWCFG_DEFAULT_EXTERNAL_I2C_PIN_MAPPING     {\
{SYS_HWCFG_I2C_SLAVE_EEPROM, 6 , 7, DEV_SWDRV_ExtI2C_ACCESS_TYPE_8BITS},   /*SFP1 on pin[6][7]*/   \
{SYS_HWCFG_I2C_SLAVE_EEPROM, 1 , 2, DEV_SWDRV_ExtI2C_ACCESS_TYPE_8BITS},    /*SFP2 on pin[1][2]*/   \
{SYS_HWCFG_I2C_SLAVE_EEPROM, 22,23, DEV_SWDRV_ExtI2C_ACCESS_TYPE_8BITS},    /*SFP3 on pin[22][23]*/ \
{SYS_HWCFG_I2C_SLAVE_EEPROM, 11,12, DEV_SWDRV_ExtI2C_ACCESS_TYPE_8BITS},    /*SFP4 on pin[11][12]*/ \
{SYS_HWCFG_I2C_SLAVE_THERMAL_0, 29,30, DEV_SWDRV_ExtI2C_ACCESS_TYPE_16BITS}, /*LM75 on pin[29][30]*/ \
{SYS_HWCFG_I2C_SLAVE_FAN_0,   29, 30, DEV_SWDRV_ExtI2C_ACCESS_TYPE_8BITS},    /*FAN  on pin[29][30]*/ \
{SYS_HWCFG_I2C_SLAVE_RETIMER, 22, 23, DEV_SWDRV_ExtI2C_ACCESS_TYPE_8BITS},  /*EQ(retimer)on pin[23][22]*/\
{SYS_HWCFG_I2C_SLAVE_THERMAL_CO, 29,30, DEV_SWDRV_ExtI2C_ACCESS_TYPE_16BITS}, /*LM77 on pin[29][30]*/ \
}

#define SYS_HWCFG_I2C_LOGICAL_ADDR_SFP_1            0x50
#define SYS_HWCFG_I2C_LOGICAL_ADDR_SFP_2            0x50
#define SYS_HWCFG_I2C_LOGICAL_ADDR_SFP_3            0x50
#define SYS_HWCFG_I2C_LOGICAL_ADDR_SFP_4            0x50


/* Thermal device
 */
#define SYS_HWCFG_SUPPORT_THERMAL                   (SYS_CPNT_THERMAL_DETECT)
#define SYS_HWCFG_MAX_NBR_OF_THERMAL_PER_UNIT       SYS_ADPT_MAX_NBR_OF_THERMAL_PER_UNIT
#define SYS_HWCFG_MAX_NBR_OF_FAN_PER_UNIT           SYS_ADPT_MAX_NBR_OF_FAN_PER_UNIT
#define SYS_HWCFG_FAN_SUPPORT_TYPE_BMP      ((1UL<<SYS_HWCFG_FAN_ADT7470))
#define SYS_HWCFG_THERMAL_SUPPORT_TYPE_BMP ((1UL<<SYS_HWCFG_THERMAL_LM75) )

#define SYS_HWCFG_FAN_SPEED_DETECT_SUPPORT          TRUE
#define SYS_HWCFG_FAN_CONTROLLER_TYPE       SYS_HWCFG_FAN_ADT7470
#define SYS_HWCFG_THERMAL_TYPE_BY_BID       TRUE
#define SYS_HWCFG_FAN_DETECT_FAN_SPEED_CONTROL_BY_BID    TRUE

/*Even THERMAL_TYPE decided by board id, it needs a default on SYS_HWCFG_THERMAL_DO_CRITICAL_TEMP_INITIAL*/
#ifdef SYS_HWCFG_THERMAL_DO_CRITICAL_TEMP_INITIAL
#define SYS_HWCFG_THERMAL_TYPE            SYS_HWCFG_THERMAL_TMP75
#endif


#define SYS_HWCFG_3FAN_FAN_SPEED_MAX    SYS_ADPT_3FAN_FAN_SPEED_FULL
#define SYS_HWCFG_1FAN_FAN_SPEED_MAX    SYS_ADPT_1FAN_FAN_SPEED_FULL
#define SYS_HWCFG_3FAN_FAN_SPEED_MID    SYS_ADPT_3FAN_FAN_SPEED_MID
#define SYS_HWCFG_1FAN_FAN_SPEED_MID    SYS_ADPT_1FAN_FAN_SPEED_MID
#if (SYS_CPNT_SYSMGMT_FAN_LOW_SPEED_MODE == TRUE) 
#define SYS_HWCFG_3FAN_FAN_SPEED_LOW                SYS_ADPT_3FAN_FAN_SPEED_LOW  
#define SYS_HWCFG_1FAN_FAN_SPEED_LOW                SYS_ADPT_1FAN_FAN_SPEED_LOW  
#define SYS_HWCFG_DEFAULT_FAN_SPEED_MODE            SYSDRV_FAN_LOW_SPEED
#endif

#define SYS_HWCFG_1FAN_FAN_SPEED_MID_BID_10    SYS_ADPT_1FAN_FAN_SPEED_MID_BID_10 
#define SYS_HWCFG_1FAN_FAN_SPEED_LOW_BID_10    SYS_ADPT_1FAN_FAN_SPEED_LOW_BID_10 

#define SYS_HWCFG_FAN_SPEED_MAX_IDX   0
#define SYS_HWCFG_FAN_SPEED_MID_IDX   1
#define SYS_HWCFG_FAN_SPEED_LOW_IDX   2
/**************************************************************
 * 3-fan board:  BID 6 & 8 & 13
 * 1-fan board:  BID 0 & 7 & 10
 * 0-fan board:  BID xx   (don't care)
 */
#define SYS_HWCFG_FAN_SPEED_WITH_MULTIPLE_BIDS_ARRAY \
{ \
/* bid 0 */ \
{SYS_HWCFG_1FAN_FAN_SPEED_MAX, SYS_HWCFG_1FAN_FAN_SPEED_MID, SYS_HWCFG_1FAN_FAN_SPEED_LOW}, \
/* bid 1 */ \
{0}, \
/* bid 2 */ \
{0}, \
/* bid 3 */ \
{0}, \
/* bid 4 */ \
{0}, \
/* bid 5 */ \
{0}, \
/* bid 6 */ \
{SYS_HWCFG_3FAN_FAN_SPEED_MAX, SYS_HWCFG_3FAN_FAN_SPEED_MID, SYS_HWCFG_3FAN_FAN_SPEED_LOW}, \
/* bid 7 */ \
{SYS_HWCFG_1FAN_FAN_SPEED_MAX, SYS_HWCFG_1FAN_FAN_SPEED_MID, SYS_HWCFG_1FAN_FAN_SPEED_LOW}, \
/* bid 8 */ \
{SYS_HWCFG_3FAN_FAN_SPEED_MAX, SYS_HWCFG_3FAN_FAN_SPEED_MID, SYS_HWCFG_3FAN_FAN_SPEED_LOW}, \
/* bid 9 */ \
{0}, \
/* bid 10 */ \
{SYS_HWCFG_1FAN_FAN_SPEED_MAX,SYS_HWCFG_1FAN_FAN_SPEED_MID_BID_10,SYS_HWCFG_1FAN_FAN_SPEED_LOW_BID_10}, \
/* bid 11 */ \
{0}, \
/* bid 12 */ \
{0}, \
/* bid 13 */ \
{SYS_HWCFG_3FAN_FAN_SPEED_MAX, SYS_HWCFG_3FAN_FAN_SPEED_MID, SYS_HWCFG_3FAN_FAN_SPEED_LOW}, \
/* bid 14 */ \
{0}, \
/* bid 15 */ \
{0}, \
}


#define SYS_HWCFG_FAN_0_FAULT_MASK  (1<<0)
#define SYS_HWCFG_FAN_1_FAULT_MASK  (1<<1)
#define SYS_HWCFG_FAN_2_FAULT_MASK  (1<<2)
#define SYS_HWCFG_FAN_3_FAULT_MASK  (1<<3)

#define SYS_HWCFG_FAN_FAULT_MASK_ARRAY            {SYS_HWCFG_FAN_0_FAULT_MASK, \
                                                   SYS_HWCFG_FAN_1_FAULT_MASK, \
                                                   SYS_HWCFG_FAN_2_FAULT_MASK, \
                                                   SYS_HWCFG_FAN_3_FAULT_MASK}

#define SYS_HWCFG_FAN_INDEX_MAPPING   \
    {1, 0, 0}, /*BID 0*/\
    {1, 0, 0}, /*BID 1*/\
    {1, 0, 0}, /*BID 2*/\
    {1, 0, 0}, /*BID 3*/\
    {1, 0, 0}, /*BID 4*/\
    {1, 0, 0}, /*BID 5*/\
    {1, 2, 3}, /*BID 6*/\
    {1, 0, 0}, /*BID 7*/\
    {1, 2, 4}, /*BID 8*/\
    {1, 0, 0}, /*BID 9*/\
    {1, 0, 0}, /*BID 10*/\
    {1, 0, 0}, /*BID 11*/\
    {1, 0, 0}, /*BID 12*/\
    {1, 2, 3}, /*BID 13*/\
    {1, 0, 0}, /*BID 14*/\
    {1, 0, 0}, /*BID 15*/\

#define SYS_HWCFG_FAN_SPEED_MID_TEMPERATURE_ARRAY \
                                          {67, /*BID 0*/\                        
                                           67, /*BID 1*/\                        
                                           67, /*BID 2*/\                        
                                           67, /*BID 3*/\                        
                                           67, /*BID 4*/\                        
                                           67, /*BID 5*/\                        
                                           81, /*BID 6*/\                        
                                           67, /*BID 7*/\                        
                                           77, /*BID 8*/\                        
                                           67, /*BID 9*/\                        
                                           67, /*BID 10*/\                       
                                           67, /*BID 11*/\                       
                                           67, /*BID 12*/\                       
                                           81, /*BID 13*/\                       
                                           67, /*BID 14*/\                       
                                           67, /*BID 15*/}                       

#define SYS_HWCFG_FAN_SPEED_LOW_TEMPERATURE_ARRAY \
                                          {52, /*BID 0*/\                       
                                           52, /*BID 1*/\                       
                                           52, /*BID 2*/\                       
                                           52, /*BID 3*/\                       
                                           52, /*BID 4*/\                       
                                           52, /*BID 5*/\                       
                                           75, /*BID 6*/\                       
                                           52, /*BID 7*/\                       
                                           74, /*BID 8*/\                       
                                           52, /*BID 9*/\                       
                                           52, /*BID 10*/\                      
                                           52, /*BID 11*/\                      
                                           52, /*BID 12*/\                      
                                           75, /*BID 13*/\                      
                                           52, /*BID 14*/\                      
                                           52, /*BID 15*/}                      
                                                   
/* The followng definitions are for build only and useless */
#define SYS_HWCFG_SYSTEM_MODULE_1_BUS_ENABLE        0x00
#define SYS_HWCFG_SYSTEM_MODULE_1_BUS_DISABLE       0x04

#define SYS_HWCFG_SYSTEM_MODULE_2_BUS_ENABLE        0x00
#define SYS_HWCFG_SYSTEM_MODULE_2_BUS_DISABLE       0x02

#define SYS_HWCFG_SYSTEM_MODULE_1_BUS_MASK          0x04
#define SYS_HWCFG_SYSTEM_MODULE_2_BUS_MASK          0x02

/* End of useless definitons */
#define SYS_HWCFG_INTGPIO                                  0
#define SYS_HWCFG_EXTGPIO                                  1
#define SYS_HWCFG_CPU_REG_BASE_ADDR   (0x18000000UL)

#define SYS_HWCFG_GPIO_CONTROL_BASE_ADDRESS         (SYS_HWCFG_CPU_REG_BASE_ADDR+0x3500)
#define SYS_HWCFG_GPIO_FUNCTION_ADDRESS             (SYS_HWCFG_GPIO_CONTROL_BASE_ADDRESS+0x0)
#define SYS_HWCFG_GPIO_DIRECTION_ADDRESS            (SYS_HWCFG_GPIO_CONTROL_BASE_ADDRESS+0x8)
#define SYS_HWCFG_GPIO_DATA_ADDRESS                 (SYS_HWCFG_GPIO_CONTROL_BASE_ADDRESS+0xC)
#define SYS_HWCFG_WATCH_DOG_GPIO_BIT_SELECT         0x00001000 /*CPU's GPIO[20]*/

#define SYS_HWCFG_MAC_REG_BASE_ADDR    (0x1B000000UL)
#define SYS_HWCFG_LED_CONTROL_BASE_ADDRESS          (SYS_HWCFG_MAC_REG_BASE_ADDR+0x00E0)
#define SYS_HWCFG_LED_GLOBAL_CTRL_ADDRESS           (SYS_HWCFG_MAC_REG_BASE_ADDR+0xE4)
#define SYS_HWCFG_LED_SET_2_3_ADDRESS               (SYS_HWCFG_MAC_REG_BASE_ADDR+0xE8)
#define SYS_HWCFG_LED_SET_0_1_ADDRESS               (SYS_HWCFG_MAC_REG_BASE_ADDR+0xEC)
#define SYS_HWCFG_LED_COPR_SET_SEL_CTRL_ADDRESS     (SYS_HWCFG_MAC_REG_BASE_ADDR+0xF0)
#define SYS_HWCFG_LED_COPR4_SET_SEL_CTRL_ADDRESS    (SYS_HWCFG_LED_COPR_SET_SEL_CTRL_ADDRESS+0xC)
#define SYS_HWCFG_LED_FIB_SET_SEL_CTRL_ADDRESS      (SYS_HWCFG_MAC_REG_BASE_ADDR+0x100)
#define SYS_HWCFG_LED_FIB4_SET_SEL_CTRL_ADDRESS     (SYS_HWCFG_LED_FIB_SET_SEL_CTRL_ADDRESS+0xC)
#define SYS_HWCFG_LED_FIB_PMASK_ADDRESS             (SYS_HWCFG_MAC_REG_BASE_ADDR+0x118)
#define SYS_HWCFG_LED_FIB_PMASK2_ADDRESS            (SYS_HWCFG_LED_FIB_PMASK_ADDRESS+4)
#define SYS_HWCFG_LED_COP_PMASK_ADDRESS             (SYS_HWCFG_MAC_REG_BASE_ADDR+0x110)
#define SYS_HWCFG_LED_COP_PMASK2_ADDRESS            (SYS_HWCFG_LED_COP_PMASK_ADDRESS+4)
#define SYS_HWCFG_LED_COMBO_CTRL_ADDRESS            (SYS_HWCFG_MAC_REG_BASE_ADDR+0x120)
#define SYS_HWCFG_LED_COMBO_CTRL2_ADDRESS           (SYS_HWCFG_LED_COMBO_CTRL_ADDRESS+4)

#define SYS_HWCFG_MAC_FORCE_BASE_ADDRESS            (SYS_HWCFG_MAC_REG_BASE_ADDR+0x02BC)

/*The id for RTL8231 doing gpio function. (other RTL8231 works as LED shift register)*/
#define SYS_HWCFG_EXTGPIO_DEVICE_ID             (1)

#define SYS_HWCFG_EXTGPIO_LED_POWER_AMBER       {0, /*BID 0*/\
                                                 0, /*BID 1*/\
                                                 0, /*BID 2*/\
                                                 0, /*BID 3*/\
                                                 0, /*BID 4*/\
                                                 0, /*BID 5*/\
                                                 3, /*BID 6*/\
                                                 0, /*BID 7*/\
                                                 33,/*BID 8*/\
                                                 0, /*BID 9*/\
                                                 32,/*BID 10*/\
                                                 0, /*BID 11*/\
                                                 0, /*BID 12*/\
                                                 3, /*BID 13*/\
                                                 0, /*BID 14*/\
                                                 0, /*BID 15*/}

#define SYS_HWCFG_EXTGPIO_LED_DIAG_AMBER        {15, /*BID 0*/\
                                                 15, /*BID 1*/\
                                                 15, /*BID 2*/\
                                                  0, /*BID 3*/\
                                                 15, /*BID 4*/\
                                                  0, /*BID 5*/\
                                                 27, /*BID 6*/\
                                                  0, /*BID 7*/\
                                                 27, /*BID 8*/\
                                                 15, /*BID 9*/\
                                                 15, /*BID 10*/\
                                                  8, /*BID 11*/\
                                                 15, /*BID 12*/\
                                                 27, /*BID 13*/\
                                                 15, /*BID 14*/\
                                                  8, /*BID 15*/}

#define SYS_HWCFG_EXTGPIO_LED_DIAG_GREEN        (27)
#define SYS_HWCFG_EXTGPIO_WD_KICK               (0)
#define SYS_HWCFG_EXTGPIO_WD_ENABLE             (31)
#define SYS_HWCFG_EXTGPIO_RESET_BUTTON          (33)
//#define SYS_HWCFG_EXTGPIO_POE_BUTTON            (36)

#define SYS_HWCFG_INTGPIO_WD_KICK_BID0_1_2         (20)
#define SYS_HWCFG_INTGPIO_WD_KICK_BID3             (12)
#define SYS_HWCFG_INTGPIO_WD_KICK_PIN_ARRAY        {20, /*BID 0*/\
                                                    20, /*BID 1*/\
                                                    20, /*BID 2*/\
                                                    12, /*BID 3*/\
                                                    20, /*BID 4*/\
                                                    12, /*BID 5*/\
                                                    12, /*BID 6*/\
                                                    12, /*BID 7*/\
                                                    12, /*BID 8*/\
                                                    20, /*BID 9*/\
                                                    20, /*BID 10*/\
                                                    12, /*BID 11*/\
                                                    12, /*BID 12*/\
                                                    12, /*BID 13*/\
                                                    20, /*BID 14*/\
                                                    12, /*BID 15*/}

#define SYS_HWCFG_INTGPIO_WD_ENABLE                (13)
#define SYS_HWCFG_INTGPIO_RESET_BUTTON             (16)

#define SYS_HWCFG_INTGPIO_FAN_FULL_SPEED_BID0      (12)
#define SYS_HWCFG_INTGPIO_SYSTEM_LED               (0)


#define SYS_HWCFG_EXTGPIO_SFP1_PRESENT          (8)
#define SYS_HWCFG_EXTGPIO_SFP2_PRESENT          (3)
#define SYS_HWCFG_EXTGPIO_SFP3_PRESENT          (24)
#define SYS_HWCFG_EXTGPIO_SFP4_PRESENT          (13)
#define SYS_HWCFG_EXTGPIO_SFP1_RXLOS            (9)
#define SYS_HWCFG_EXTGPIO_SFP2_RXLOS            (4)
#define SYS_HWCFG_EXTGPIO_SFP3_RXLOS            (25)
#define SYS_HWCFG_EXTGPIO_SFP4_RXLOS            (14)


#define SYS_HWCFG_INTGPIO_SFP1_RXLOS            (18)
#define SYS_HWCFG_INTGPIO_SFP2_RXLOS            (19)
#define SYS_HWCFG_INTGPIO_SFP3_RXLOS            (20)
#define SYS_HWCFG_INTGPIO_SFP4_RXLOS            (21)

/* CPU's gpio pin is listed from MSB.
 * GPIO  7~ 0 belong to group A, occupies Bit[31:24].
 * GPIO 15~ 8 belong to group B, occupies Bit[23:16].
 * GPIO 23~16 belong to group C, occupies Bit[15: 8]. 
 */
#define SYS_HWCFG_GET_GPIO_BIT_OFFSET(pin_num)  ((3-(pin_num/8))*8+(pin_num%8))

#define SYS_HWCFG_INTGPIO_POE_STATUS            (23)
#define SYS_HWCFG_INTGPIO_POE_INT               (22)
#define SYS_HWCFG_EXTGPIO_POE_RESET             (4)
#define SYS_HWCFG_EXTGPIO_POE_DISABLE           (9)
#define SYS_HWCFG_INTGPIO_POE_RESET             (18)
#define SYS_HWCFG_INTGPIO_POE_DISABLE           (16)

/* Only 10-port models has tx-disable, because no external phy on these fiber ports.
 * The 28port models use phy to control tx_disable.
 */
#define SYS_HWCFG_EXTGPIO_SFP1_TX_DISABLE       (24)
#define SYS_HWCFG_EXTGPIO_SFP2_TX_DISABLE       (13)
#define SYS_HWCFG_EXTGPIO_TX_DISABLE_ARRAY      {SYS_HWCFG_EXTGPIO_SFP1_TX_DISABLE, SYS_HWCFG_EXTGPIO_SFP2_TX_DISABLE}

/* PoE controller reset bits
 */
#define SYS_HWCFG_SYSTEM_RESET_POE_SOFTWARE_RESET_BID_1         0x10
#define SYS_HWCFG_SYSTEM_RESET_POE_SOFTWARE_RESET_BID_3         0x01
#define SYS_HWCFG_SYSTEM_RESET_POE_ENABLE                       0x40

/* For PoE Power Allocation
*/
#define SYS_HWCFG_MAX_POWER_ALLOCATION_EXTRA        SYS_DFLT_MAIN_PSE_POWER_MAX_ALLOCATION
#define SYS_HWCFG_MAX_POWER_ALLOCATION_LOCAL        SYS_DFLT_MAIN_PSE_POWER_MAX_ALLOCATION
#define SYS_HWCFG_MAX_POWER_ALLOCATION              (SYS_DFLT_MAIN_PSE_POWER_MAX_ALLOCATION + SYS_HWCFG_MAX_POWER_ALLOCATION_LOCAL)
#define SYS_HWCFG_MIN_POWER_ALLOCATION              SYS_DFLT_MAIN_PSE_POWER_MIN_ALLOCATION
#define SYS_HWCFG_MAX_POWER_INLINE_ALLOCATION       SYS_DFLT_PSE_PORT_POWER_MAX_ALLOCATION
#define SYS_HWCFG_MIN_POWER_INLINE_ALLOCATION       SYS_DFLT_PSE_PORT_POWER_MIN_ALLOCATION

/* Joeanne add for mode(duplex/PoE) button*/
#define SYS_HWCFG_BOARD_BUTTON_MASK                 0x00    /* 00100000 */
#define SYS_HWCFG_BOARD_BUTTON_PRESSED              0xFF    /* not innvalid */
#define SYS_HWCFG_BOARD_BUTTON_UNPRESSED            0x00    /* not innvalid */
#define SYS_HWCFG_BOARD_PORT_MASK                   0x80
#define SYS_HWCFG_BOARD_ID_24                       0x00
#define SYS_HWCFG_BOARD_ID_48                       0x01

/* UART device name on linux.
 * it is necessary to define SYS_HWCFG_UART_CHANNEL2_DEVICE_NAME when
 * support second UART.
 */
#define SYS_HWCFG_UART_CHANNEL1_DEVICE_NAME  "/dev/ttyS0"
#undef  SYS_HWCFG_UART_CHANNEL2_DEVICE_NAME

#define SYS_HWCFG_FLASH_MTD_NAME_LEN        32

/* Information of PCE's
 */
#define SYS_HWCFG_MAX_NBR_OF_PCL_PER_CHIP                   512 /* 10 bits */
#define SYS_HWCFG_MAX_NBR_OF_PCE_PER_CHIP                   512
#define SYS_HWCFG_MAX_METER_ENTRY_NUM                       256
#define SYS_HWCFG_MAX_NBR_OF_EGRESS_METER_PER_CHIP          0

#define SYS_HWCFG_MAX_NBR_OF_I2C_CHANNEL                    8

#define SYS_HWCFG_PCA9548_CHANNEL_0                         1 /* PD69012 */
#define SYS_HWCFG_PCA9548_CHANNEL_1                         2 /* SFP 1 */
#define SYS_HWCFG_PCA9548_CHANNEL_2                         3 /* SFP 2 */
#define SYS_HWCFG_PCA9548_CHANNEL_3                         4 /* SFP 3 */
#define SYS_HWCFG_PCA9548_CHANNEL_4                         5 /* SFP 4 */
#define SYS_HWCFG_PCA9548_CHANNEL_5                         6 /* CPLD */
#define SYS_HWCFG_PCA9548_CHANNEL_6                         7
#define SYS_HWCFG_PCA9548_CHANNEL_7                         8

#define SYS_HWCFG_PCA9548_DATAADDR                          0
#define SYS_HWCFG_PCA9548_DEFAULT_CHANNEL                   0

#define SYS_HWCFG_NUM_OF_I2C_MUX                            1
#define SYS_HWCFG_I2C_MUX_ADDR_ARRAY                        {SYS_HWCFG_I2C_PHYSICAL_ADDR_RTL8231}

#define SYS_HWCFG_I2C_PHYSICAL_ADDR_PCA9548                 0x70
#define SYS_HWCFG_I2C_SLAVE_CPLD                            0x52
#define SYS_HWCFG_I2C_PHYSICAL_ADDR_CPLD                    0x52
#define SYS_HWCFG_I2C_PHYSICAL_ADDR_CPLD_SFP_STATUS_1       0x3
#define SYS_HWCFG_I2C_PHYSICAL_ADDR_CPLD_SFP_STATUS_2       0x4
#define SYS_HWCFG_I2C_PHYSICAL_ADDR_CPLD_CODE_REVISION      0x5
#define SYS_HWCFG_I2C_PHYSICAL_ADDR_CPLD_SFP_CONTROL        0x12

#define SYS_HWCFG_I2C_PHYSICAL_ADDR_RTL8231                 0x0
/* Define SYS_HWCFG_I2C_INIT_PHERIPHERAL as TRUE if
 * the project need to init pheripheral through I2C bus.
 * SYS_HWCFG_GetI2CPeripheralInitOpers() must be implemented when
 * SYS_HWCFG_I2C_INIT_PHERIPHERAL is TRUE.
 */
#define SYS_HWCFG_I2C_INIT_PHERIPHERAL FALSE

/* used when SYS_CPNT_SELECT_CHANNEL_MODE==SYS_CPNT_SELECT_CHANNEL_MODE__GPIO -- START
 */
#define SYS_HWCFG_GPIO_CHANNEL_MODE_MAX_NBR_OF_CHANNEL 4

/* To convert channel_bmp to mux, must config
 * bit_19 as SFP_mux_sel[1]
 * bit_18 as SFP_mux_sel[0]
 * as the following table
 * Note that HW and HW SPEC is little-endian design
 * Accton uboot and platform is big-endian design
 *=============================================================================================================
 * Port # channel #    SFP_mux_sel[1]   SFP_mux_sel[0] bit23 bit22 bit21 bit20 bit19 bit18 bit17 bit16    HEX
 *     25         1                0                0      0     0     0     0     0     0     0     0    0x00
 *     26         2                0                1      0     0     0     0     0     1     0     0    0x04
 *     27         3                1                0      0     0     0     0     1     0     0     0    0x08
 *     28         4                1                1      0     0     0     0     1     1     0     0    0x0C
 *=============================================================================================================
 * For the SYS_HWCFG_GPIO_SET_CHANNEL_INFO_ARRAY,
 * please reference I2C_GpioChannelModeInfoEntry_T in i2c.h
 */
#define SYS_HWCFG_GPIO_SET_CHANNEL_INFO_ARRAY \
    { \
        {SYS_HWCFG_GPIO_LOW_DATA_OUT_16_23, 0x0C, 0x00}, /*channel 1 */ \
        {SYS_HWCFG_GPIO_LOW_DATA_OUT_16_23, 0x0C, 0x04}, /*channel 2 */ \
        {SYS_HWCFG_GPIO_LOW_DATA_OUT_16_23, 0x0C, 0x08}, /*channel 3 */ \
        {SYS_HWCFG_GPIO_LOW_DATA_OUT_16_23, 0x0C, 0x0C}, /*channel 4 */ \
    }
/* used when SYS_CPNT_SELECT_CHANNEL_MODE==SYS_CPNT_SELECT_CHANNEL_MODE__GPIO -- END
 */

#if (TRUE == SYS_CPNT_SWDRV_SFP_RX_LOS_INTERRUPT)
#define SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_6 \
     {\
         25,26,27,28, /*RX los port mapping */ \
     }

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum drv_gpio_port_e
 */
#define SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_6 \
    { \
        {2, 2}, /* C 2 */ \
        {2, 3}, /* C 3 */ \
        {2, 4}, /* C 4 */ \
        {2, 5}, /* C 5 */ \
    }

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum GPIO_INTERNAL_PIN
 */
#define SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_6 \
    { \
      18, 19, 20, 21, /* C2, C3, C4, C5 */ \
    }

#define SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_8 \
     {\
         49,50,51,52, /*RX los port mapping */ \
     }

#define SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_8 \
    { \
        {2, 2}, /* C 2 */ \
        {2, 3}, /* C 3 */ \
        {2, 4}, /* C 4 */ \
        {2, 5}, /* C 5 */ \
    }

#define SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_8 \
    { \
      18, 19, 20, 21, /* C2, C3, C4, C5 */ \
    }

#define SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_10 \
     {\
         9,10,11,12, /*RX los port mapping */ \
     }

#define SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_10 \
    { \
        {1, 4}, /* B 4 */ \
        {1, 6}, /* B 6 */ \
        {2, 5}, /* C 5 */ \
        {2, 6}, /* C 6 */ \
    }

#define SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_10 \
    { \
      12, 14, 21, 22, /* B4, B6, C5, C6 */ \
    }

#define SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_11   SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_6

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum drv_gpio_port_e
 */
#define SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_11   SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_6

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum GPIO_INTERNAL_PIN
 */
#define SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_11     SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_6

#define SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_12   SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_11

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum drv_gpio_port_e
 */
#define SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_12   SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_11

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum GPIO_INTERNAL_PIN
 */
#define SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_12     SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_11

#define SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_13   SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_6

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum drv_gpio_port_e
 */
#define SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_13   SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_6

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum GPIO_INTERNAL_PIN
 */
#define SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_13     SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_6

#define SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_15   SYS_HWCFG_RX_LOS_PORT_MAPPING_BID_11

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum drv_gpio_port_e
 */
#define SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_15   SYS_HWCFG_RX_LOS_GPIO_MAPPING_BID_11

/* refer to /sdk_2.1.4/system/include/drv/gpio/gpio.h
 * enum GPIO_INTERNAL_PIN
 */
#define SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_15     SYS_HWCFG_RX_LOS_GPIO_INDEX_BID_11

#endif /* #if (TRUE == SYS_CPNT_SWDRV_SFP_RX_LOS_INTERRUPT) */

typedef struct SYS_HWCFG_FlashEntry_S
{
    UI32_T  mtdnum;
    UI32_T  address;
    UI32_T  size;
    UI32_T  type;
    BOOL_T  writeable;
    UI8_T   name[SYS_HWCFG_FLASH_MTD_NAME_LEN];
} SYS_HWCFG_FlashEntry_T;

typedef struct PHYSICAL_EPLD_ADDR_S
{
    UI32_T start_addr;              /*the start address of EPLD*/
    UI32_T end_addr;                /*the end address of EPLD*/
} PHYSICAL_EPLD_ADDR_T;

typedef enum SYS_HWCFG_74HC4051DT_EVENT_E
{
    SYS_HWCFG_74HC4051DT_EVENT_MIN = 0,
    SYS_HWCFG_74HC4051DT_EVENT_FE_FAN1_FAIL,
    SYS_HWCFG_74HC4051DT_EVENT_FE_POE_BUTTON,
    SYS_HWCFG_74HC4051DT_EVENT_GE_FAN1_FAIL,
    SYS_HWCFG_74HC4051DT_EVENT_GE_FAN2_FAIL,
    SYS_HWCFG_74HC4051DT_EVENT_MAX
} SYS_HWCFG_74HC4051DT_EVENT_T;

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_GetGBIC_I2CMuxAndChannelInfo
 *---------------------------------------------------------------------------------
 * PURPOSE: Get I2C multiplexer device index and channel info.
 * INPUT:   board_id       : board id
 *          device_index   : SFP port index (1 based)
 * OUTPUT:  i2c_mux_idx_p  : I2C multiplexer index for the given sfp port index
 *          channel_p      : I2C device channel for the given sfp port index (1 based)
 * RETUEN:  TRUE   -  Success
 *          FALSE  -  Failed
 * NOTES:
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetGBIC_I2CMuxAndChannelInfo(UI32_T board_id, UI32_T device_index, UI32_T *i2c_mux_idx_p, UI8_T *channel_p);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_SwitchChip_MiscInit
 *---------------------------------------------------------------------------------
 * PURPOSE: config EPLD important bit for module
 * INPUT:
 * OUTPUT:
 * RETUEN:  TRUE/FALSE
 * NOTES:
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_SwitchChip_MiscInit(void);
BOOL_T SYS_HWCFG_Getepldaddr(PHYSICAL_EPLD_ADDR_T *epldaddr);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_GetI2CPeripheralInitOpers
 *---------------------------------------------------------------------------------
 * PURPOSE: Output I2C peripheral initialization operations.
 * INPUT:   board_id        --   board id.
 * OUTPUT:  i2c_trans_lst_pp--   i2c peripheral initialization transactions list
 *          lst_size_p      --   list size of i2c_trans_lst_p
 * RETUEN:  TRUE if success. FALSE if failed.
 * NOTES:   This function is called when SYS_HWCFG_I2C_INIT_PHERIPHERAL is TRUE.
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetI2CPeripheralInitOpers(UI32_T board_id, const SYS_HWCFG_I2CTransactionEntry_T **i2c_trans_lst_pp, UI32_T* lst_size_p);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_GetSFPTxDisableRegInfo
 *---------------------------------------------------------------------------------
 * PURPOSE: Get the register info for control SFP Tx disable signal
 * INPUT:   board_id  --   board id.
 *          port      --   port id.
 * OUTPUT:  reg_info_p--   list size of i2c_trans_lst_p
 * RETUEN:  TRUE if success. FALSE if failed.(The given port do not support to control tx disable signal)
 * NOTES:   This function is called when SYS_HWCFG_SUPPORT_SFP_TX_DISABLE is TRUE.
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetSFPTxDisableRegInfo(UI32_T board_id, UI32_T port, SYS_HWCFG_SFPTxDisableRegInfo_T *reg_info_p);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_SetSFPTxDisable
 *---------------------------------------------------------------------------------
 * PURPOSE: Set the register info for control SFP Tx disable signal
 * INPUT:   board_id  --   board id.
 *          port      --   port id.
 * OUTPUT:  enable --   enable or not
 * RETUEN:  None
 * NOTES:   This function is called when SYS_HWCFG_SUPPORT_SFP_TX_DISABLE is TRUE.
 *---------------------------------------------------------------------------------
 */
void SYS_HWCFG_SetSFPTxDisable(UI32_T board_id, UI32_T port, BOOL_T enable);

/* FUNCTION NAME: SYS_HWCFG_GetThermalRegInfo
 *-----------------------------------------------------------------------------
 * PURPOSE: This function provides the register information to access thermal
 *          register
 *-----------------------------------------------------------------------------
 * INPUT    : board_id    -  which board id
 *            thermal_idx -  which thermal (idx starts from 0)
 * OUTPUT   : info_p      -  the register info for thermal
 * RETURN   : TRUE if get sucessfully.
 *-----------------------------------------------------------------------------
 * NOTES: This API is used when
 *        (SYS_CPNT_THERMAL_DETECT == TRUE)
 */
BOOL_T SYS_HWCFG_GetThermalRegInfo(UI32_T board_id, UI32_T thermal_idx, SYS_HWCFG_ThermalRegInfo_T* info_p);

#if (SYS_HWCFG_THERMAL_TYPE_BY_BID == TRUE)
/* FUNCTION NAME: SYS_HWCFG_GetThermalTypeByBID
 *-----------------------------------------------------------------------------
 * PURPOSE: Get thermal sensor types of a thermal index of a board.
 *-----------------------------------------------------------------------------
 * INPUT    : board_id    -  which board id
 *            thermal_idx -  which thermal (idx starts from 0)
 * OUTPUT   : type        -  type of thermel sensor IC.
 * RETURN   : TRUE if get sucessfully.
 *-----------------------------------------------------------------------------
 * NOTES: None
 */
BOOL_T SYS_HWCFG_GetThermalTypeByBID(
    UI32_T board_id, UI32_T thermal_idx, UI32_T *type);
#endif /*#if (SYS_HWCFG_THERMAL_TYPE_BY_BID == TRUE)*/

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_GetSFPPresentStatus
 *---------------------------------------------------------------------------------
 * PURPOSE: Get the present status for control SFP port
 * INPUT:   board_id  --   board id.
 *          sfp_index
 * OUTPUT:  status_p
 * RETUEN:  TRUE/FALSE
 * NOTES:
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetSFPPresentStatus(UI32_T board_id, UI32_T sfp_index, UI8_T *status_p);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_GetSFPRXLOSStatus
 *---------------------------------------------------------------------------------
 * PURPOSE: Get the rx loss status for control SFP port
 * INPUT:   board_id  --   board id.
 *          sfp_index
 * OUTPUT:  status_p
 * RETUEN:  TRUE/FALSE
 * NOTES:
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetSFPRXLOSStatus(UI32_T board_id, UI32_T sfp_index, UI8_T *status_p);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_ConfigGPIODirection
 *---------------------------------------------------------------------------------
 * PURPOSE: To config GPIO pin as Input pin or Output pin
 * INPUT  : pin_num         : index of GPIO pin
 *          is_input_pin    : True for input pin; False for output pin
 *          default_value   : output value
 *          wait_time       : IPC wait time for response.
 * OUTPUT : None
 * RETUEN : TRUE for Configure success; False for Configure fail
 * NOTES  : GPIO configuration must be protected in Critical Section
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_ConfigGPIODirection(UI32_T pin_num, BOOL_T is_input_pin, UI32_T default_value, UI32_T wait_time);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_WriteGPIO
 *---------------------------------------------------------------------------------
 * PURPOSE: To write value on GPIO output pin
 * INPUT  : pin_num: index of GPIO pin
 *          value: O or 1
*           wait_time       : IPC wait time for response.
 * OUTPUT : None
 * RETUEN : TRUE for writing success; False for writing fail
 * NOTES  : GPIO configuration must be protected in Critical Section
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_WriteGPIO(UI32_T pin_num, BOOL_T value, UI32_T wait_time);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_WriteInternalGPIO
 *---------------------------------------------------------------------------------
 * PURPOSE: To write value on GPIO output pin
 * INPUT  : pin_num: index of GPIO pin
 *          value: O or 1
 * OUTPUT : None 
 * RETUEN : TRUE for writing success; False for writing fail
 * NOTES  : GPIO configuration must be protected in Critical Section
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_WriteInternalGPIO(UI32_T pin_num, BOOL_T value);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_ReadGPIO
 *---------------------------------------------------------------------------------
 * PURPOSE: To read value from GPIO input pin
 * INPUT  : pin_num: index of GPIO pin
 *          value: O or 1
 * OUTPUT : None
 * RETUEN : TRUE for reading success; False for reading fail
 * NOTES  : GPIO configuration must be protected in Critical Section
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_ReadGPIO(UI32_T pin_num, BOOL_T *value);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_ReadInternalGPIO
 *---------------------------------------------------------------------------------
 * PURPOSE: To read value from GPIO input pin
 * INPUT  : pin_num: index of GPIO pin
 *          value: O or 1
 * OUTPUT : None 
 * RETUEN : TRUE for reading success; False for reading fail
 * NOTES  : GPIO configuration must be protected in Critical Section
 *          RTK CPU's gpio pin is listed from MSb. Eg. pin 20 control is 0x00001000. 
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_ReadInternalGPIO(UI32_T pin_num, BOOL_T *value);

/* -------------------------------------------------------------------------
 * ROUTINE NAME - SYS_HWCFG_Read74HC4051DT
 * -------------------------------------------------------------------------
 * FUNCTION: This function performs preprocessing to read status
 *           from 74HC4051DT
 * INPUT   : event: The event for 74HC4051DT
 * OUTPUT  : status: The status of event process
 * RETURN  : TRUE: The output data is valid
 *           FALSE: The output data is invalid
 * NOTE    : Refer HW design SPEC firstly!
 * -------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_Read74HC4051DT(SYS_HWCFG_74HC4051DT_EVENT_T event, BOOL_T *status);

/* -------------------------------------------------------------------------
 * ROUTINE NAME - SYS_HWCFG_GetCPLDRegister
 * -------------------------------------------------------------------------
 * FUNCTION: This function performs preprocessing to read data from CPLD register
 * INPUT   : offset: The register offset of CPLD
 * OUTPUT  : data: The value to be readed from the specified CPLD register
 * RETURN  : TRUE: The output data is valid
 *           FALSE: The output data is invalid
 * NOTE    : Refer HW design SPEC firstly!
 * -------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetCPLDRegister(UI32_T offset, UI8_T *data);

/* -------------------------------------------------------------------------
 * ROUTINE NAME - SYS_HWCFG_SetCPLDRegister
 * -------------------------------------------------------------------------
 * FUNCTION: This function performs preprocessing to write data into CPLD register
 * INPUT   : offset: The register offset of CPLD
 *           data: The value to be written to the specified CPLD register
 * OUTPUT  : None
 * RETURN  : TRUE: If success
 *           FALSE: If failed
 * NOTE    : Refer HW design SPEC firstly!
 * -------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_SetCPLDRegister(UI32_T offset, UI8_T data);

#if (SYS_HWCFG_FAN_DETECT_FAN_STATUS_BY_BID == TRUE)

/* -------------------------------------------------------------------------
 * ROUTINE NAME - SYS_HWCFG_GetFANStatusByBID
 * -------------------------------------------------------------------------
 * FUNCTION: This function performs preprocessing to read FAN status by BID
 * INPUT   : board_id: The board id for system
 *           nbr_of_fan: The FAN device number for system
 * OUTPUT  : local_unit_fan_status: The FAN status for system
 * RETURN  : TRUE: The output data is valid
 *           FALSE: The output data is invalid
 * NOTE    : Refer HW design SPEC firstly!
 * -------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetFANStatusByBID(UI32_T board_id, UI8_T nbr_of_fan, UI8_T *local_unit_fan_status);
#endif

#if (SYS_CPNT_STKTPLG_FAN_DETECT == TRUE) && (SYS_HWCFG_FAN_DETECT_FAN_SPEED_CONTROL_BY_BID == TRUE)

/* -------------------------------------------------------------------------
 * ROUTINE NAME - SYS_HWCFG_SetFanSpeedModeByBID
 * -------------------------------------------------------------------------
 * FUNCTION: This function performs preprocessing to write FAN speed by BID
 * INPUT   : board_id: The board id for system
 *           temperature: The temperature for system
 *           local_unit_fan_speed_mode: The previous FAN speed for system
 * OUTPUT  : local_unit_fan_speed_mode: The current FAN speed for system
 * RETURN  : TRUE: The output data is valid
 *           FALSE: The output data is invalid
 * NOTE    : Refer HW design SPEC firstly!
 * -------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_SetFanSpeedModeByBID(UI32_T board_id, I32_T temperature, UI32_T *local_unit_fan_speed_mode);
#endif


UI32_T SYS_HWCFG_GetWatchDogKickMethod (UI32_T board_id, UI8_T *hw_ver_p);
BOOL_T SYS_HWCFG_KickWatchDog(UI32_T board_id,UI32_T method);
BOOL_T SYS_HWCFG_DisableWatchDog(UI32_T board_id);
BOOL_T SYS_HWCFG_EnableWatchDog(UI32_T board_id);
BOOL_T SYS_HWCFG_InitWatchDogKickMethod(UI32_T board_id, UI32_T wd_kick_method);
BOOL_T SYS_HWCFG_InitWatchDog(void);
BOOL_T SYS_HWCFG_ConfigInternalGPIODirection(UI32_T pin_num, BOOL_T is_input_pin);
BOOL_T SYS_HWCFG_ConfigInternalGPIOFcuntion(UI32_T pin_num, BOOL_T is_gpio_pin);
BOOL_T SYS_HWCFG_GetResetButtonStatus(UI32_T board_id, BOOL_T *is_pressed);
BOOL_T SYS_HWCFG_GetFanRegInfo(UI32_T board_id, UI32_T fan_idx, SYS_HWCFG_FanRegInfo_T* info_p);
BOOL_T SYS_HWCFG_GetThermalRegInfo(UI32_T board_id, UI32_T thermal_idx, SYS_HWCFG_ThermalRegInfo_T* info_p);
#if (SYS_HWCFG_FAN_HAS_FULL_SPEED_PIN == TRUE)
BOOL_T SYS_HWCFG_SetFanFullSpeedPin(UI32_T board_id, UI32_T fan_idx, BOOL_T enable);
#endif /*#if (SYS_HWCFG_FAN_HAS_FULL_SPEED_PIN == TRUE)*/

/* -------------------------------------------------------------------------
 * ROUTINE NAME - SYS_HWCFG_DyingGaspPortEnable
 * -------------------------------------------------------------------------
 * FUNCTION: enable/disable dying gasp function on a port
 * INPUT   : port       --which port
 *           enable     --TRUE: to enable. FALSE: to disable
 * OUTPUT  : None
 * RETURN  : FALSE on error, otherwise, TRUE.
 * NOTE    :
 * -------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_DyingGaspPortEnable(UI32_T port, BOOL_T enable);

/* -------------------------------------------------------------------------
 * FUNCTION NAME - SYS_HWCFG_SetPortDyingGaspPacket
 * -------------------------------------------------------------------------
 * PURPOSE : Set the packet content for dying gasp on a port
 * INPUT   : unit  -- which unit.
 *           port  -- which port.
 *           packet_p  -- Dying Gasp packet
 *           packet_len  -- packet length, the max value is SYS_ADPT_MAX_FRAME_SIZE
 * OUTPUT  : None
 * RETURN  : True: Successfully, FALSE: Failed
 * NOTE    : None
 * -------------------------------------------------------------------------*/
BOOL_T SYS_HWCFG_SetPortDyingGaspPacket(UI32_T unit, UI32_T port, void* packet_p, UI32_T packet_len);

/* -------------------------------------------------------------------------
 * FUNCTION NAME - SYS_HWCFG_ClearPortDyingGaspPacket
 * -------------------------------------------------------------------------
 * PURPOSE : Clear the packet content for dying gasp on a port
 * INPUT   : unit  -- which unit.
 *           port  -- which port.
 * OUTPUT  : None
 * RETURN  : True: Successfully, FALSE: Failed
 * NOTE    : disable dying gasp function
 * -------------------------------------------------------------------------*/
BOOL_T SYS_HWCFG_ClearPortDyingGaspPacket(UI32_T unit, UI32_T port);

/* -------------------------------------------------------------------------
 * ROUTINE NAME - SYS_HWCFG_SetPortForceLink
 * -------------------------------------------------------------------------
 * FUNCTION: enable/disable function of forcing link up
 * INPUT   : device_id    -- which device
 *           phy_port     --which port
 *           enable       --TRUE: to enable. FALSE: to disable
 * OUTPUT  : None
 * RETURN  : FALSE on error, otherwise, TRUE.
 * NOTE    :
 * -------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_SetPortForceLink(UI32_T device_id, UI32_T phy_port, BOOL_T link_up);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_GetPortLedColorEntity
 *---------------------------------------------------------------------------------
 * PURPOSE: Get corresponding LED enteity for the color
 * INPUT  : board_id        : index of GPIO pin
 *          color           : GREEN, AMBER, or others
 * OUTPUT : entity          : which LED pin control 
 * RETUEN : TRUE for success; False for fail
 * NOTES  : Here assumes all ports share same mapping between color and entity.
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetPortLedColorEntity(UI32_T board_id, UI8_T color, UI8_T *entity);

#if (TRUE == SYS_CPNT_SWDRV_SFP_RX_LOS_INTERRUPT)
/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_IsRxLosIntSupported
 *---------------------------------------------------------------------------------
 * PURPOSE: To check if this board handle rx los interrupt or not
 * INPUT  : board_id: 0 ~ KNOWN_MAX_BOARD_ID
 * OUTPUT : TRUE for support; FALSE for no support
 * RETUEN : TRUE for success; False for fail
 * NOTES  :
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_IsRxLosIntSupported(UI32_T board_id, BOOL_T *is_supported);

/*---------------------------------------------------------------------------------
 * FUNCTION NAME: SYS_HWCFG_GetRxLosPortMapping
 *---------------------------------------------------------------------------------
 * PURPOSE: To get rx los interrupt mapping port
 * INPUT  : board_id: 0 ~ KNOWN_MAX_BOARD_ID
 * OUTPUT : mapping :
 * RETUEN : TRUE for success; False for fail
 * NOTES  :
 *---------------------------------------------------------------------------------
 */
BOOL_T SYS_HWCFG_GetRxLosPortMapping(UI32_T board_id, UI8_T *mapping);
#endif /* #if (TRUE == SYS_CPNT_SWDRV_SFP_RX_LOS_INTERRUPT) */

#endif  /*#ifndef SYS_HWCFG_H*/
/* End of SYS_HWCFG.H */

